% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_prcomp.R
\name{plot_prcomp}
\alias{plot_prcomp}
\title{Plot PCA of subsampled data using ggplot}
\usage{
plot_prcomp(
  df_samples,
  protein_names,
  color_var = "treatment",
  subsample_size = 10000,
  repel = TRUE
)
}
\arguments{
\item{df_samples}{Data frame or tibble with proteins counts,
cell condition, and group information}

\item{protein_names}{A vector of column names of protein to use in the
analysis}

\item{color_var}{A column name}

\item{subsample_size}{Subsample per color_var variable}

\item{repel}{Repel labels}
}
\value{
\code{\link[cowplot]{cowplot}} object
}
\description{
Plot PCA of subsampled data using ggplot
}
\examples{
set.seed(23)
df <- generate_data()
protein_names <- names(df)[3:12]
df <- dplyr::mutate_at(df, protein_names, function(x) asinh(x/5))
CytoGLMM::plot_prcomp(df,
                      protein_names = protein_names,
                      color_var = "condition")
}
