% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesFilter.R
\name{StringBasedFiltering2}
\alias{StringBasedFiltering2}
\title{Removes lines in the dataset based on a prefix strings.}
\usage{
StringBasedFiltering2(obj, cname = NULL, tag = NULL)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}

\item{cname}{The name of the column that correspond to the line to filter}

\item{tag}{A character string that is the prefix for the contaminants to
find in the data}
}
\value{
An list of 4 items :
* obj : an object of class \code{MSnSet} in which the lines have been deleted
* deleted : an object of class \code{MSnSet} which contains the deleted lines
}
\description{
Removes lines in the dataset based on a prefix strings.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj.filter <- StringBasedFiltering2(Exp1_R25_pept[seq_len(100)], 
"Potential_contaminant", "+")

}
\author{
Samuel Wieczorek
}
