% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell_Plots.R
\name{hc_mvTypePlot2}
\alias{hc_mvTypePlot2}
\title{Distribution of Observed values with respect to intensity values}
\usage{
hc_mvTypePlot2(obj, pal = NULL, pattern, typeofMV = NULL, title = NULL)
}
\arguments{
\item{obj}{xxx}

\item{pal}{The different colors for conditions}

\item{pattern}{xxx}

\item{typeofMV}{xxx}

\item{title}{The title of the plot}
}
\value{
Density plots
}
\description{
This method shows density plots which represents the repartition of
Partial Observed Values for each replicate in the dataset.
The colors correspond to the different conditions (slot Condition in in the
dataset of class \code{MSnSet}).
The x-axis represent the mean of intensity for one condition and one
entity in the dataset (i. e. a protein)
whereas the y-axis count the number of observed values for this entity
and the considered condition.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(100)]
conds <- Biobase::pData(obj)$Condition
pal <- ExtendPalette(length(unique(conds)), "Dark2")
hc_mvTypePlot2(obj, pattern = "Missing MEC", title = "POV distribution", pal = pal)

}
\author{
Samuel Wieczorek
}
