% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingValuesImputation_ProteinLevel.R
\name{wrapper.impute.fixedValue}
\alias{wrapper.impute.fixedValue}
\title{Missing values imputation from a \code{MSnSet} object}
\usage{
wrapper.impute.fixedValue(obj, fixVal = 0, na.type)
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}

\item{fixVal}{A float.}

\item{na.type}{A string which indicates the type of missing values to impute.
Available values are: `NA` (for both POV and MEC), `POV`, `MEC`.}
}
\value{
The object \code{obj} which has been imputed
}
\description{
This method is a wrapper to objects of class \code{MSnSet} and imputes 
missing values with a fixed value.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
obj <- Exp1_R25_pept[seq_len(10), ]
obj.imp.pov <- wrapper.impute.fixedValue(obj, 0.001, na.type = "Missing POV")
obj.imp.mec <- wrapper.impute.fixedValue(obj, 0.001, na.type = "Missing MEC")
obj.imp.na <- wrapper.impute.fixedValue(obj, 0.001, na.type = c("Missing MEC", "Missing POV"))

}
\author{
Samuel Wieczorek
}
