% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffAnalysis.R
\name{wrapperCalibrationPlot}
\alias{wrapperCalibrationPlot}
\title{Performs a calibration plot on an \code{MSnSet} object,
calling the \code{cp4p} package functions.}
\usage{
wrapperCalibrationPlot(vPVal, pi0Method = "pounds")
}
\arguments{
\item{vPVal}{A dataframe that contains quantitative data.}

\item{pi0Method}{A vector of the conditions (one condition per sample).}
}
\value{
A plot
}
\description{
This function is a wrapper to the calibration.plot method of the
\code{cp4p} package for use with \code{MSnSet} objects.
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot[seq_len(100)]
level <- 'protein'
metacell.mask <- match.metacell(GetMetacell(obj), c("Missing POV", "Missing MEC"), level)
indices <- GetIndices_WholeMatrix(metacell.mask, op = ">=", th = 1)
obj <- MetaCellFiltering(obj, indices, cmd = "delete")
qData <- Biobase::exprs(obj$new)
sTab <- Biobase::pData(obj$new)
limma <- limmaCompleteTest(qData, sTab)
wrapperCalibrationPlot(limma$P_Value[, 1])

}
\author{
Samuel Wieczorek
}
