% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova_analysis.R
\name{wrapperClassic1wayAnova}
\alias{wrapperClassic1wayAnova}
\title{Wrapper for One-way Anova statistical test}
\usage{
wrapperClassic1wayAnova(obj, with_post_hoc = "No", post_hoc_test = "No")
}
\arguments{
\item{obj}{An object of class \code{MSnSet}.}

\item{with_post_hoc}{a character string with 2 possible values: "Yes" and
"No" (default) saying if function must perform a Post-Hoc test or not.}

\item{post_hoc_test}{character string, possible values are "No" (for no
test; default value) or TukeyHSD" or "Dunnett". See details of
\code{postHocTest()} function to choose the appropriate one.}
}
\value{
A list of two dataframes. First one called "logFC" contains
all pairwise comparisons logFC values (one column for one comparison) for
each analysed feature (Except in the case without post-hoc testing, for
which NAs are returned.); The second one named "P_Value" contains the
corresponding p-values.
}
\description{
Wrapper for One-way Anova statistical test
}
\details{
This function allows to perform a 1-way Analysis of Variance. Also
computes the post-hoc tests if the \code{with_post_hoc} parameter is set to
yes. There are two possible post-hoc tests: the Tukey Honest Significant
Differences (specified as "TukeyHSD") and the Dunnett test
(specified as "Dunnett").
}
\examples{
\dontrun{examples/ex_wrapperClassic1wayAnova.R}

}
\seealso{
[postHocTest()]
}
\author{
Hélène Borges
}
