% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{get_results}
\alias{get_results}
\title{Generate a results table}
\usage{
get_results(dep)
}
\arguments{
\item{dep}{SummarizedExperiment,
Data object for which differentially enriched proteins are annotated
(output from \code{\link{test_diff}()} and \code{\link{add_rejections}()}).}
}
\value{
A data.frame object
containing all results variables from the performed analysis.
}
\description{
\code{get_results} generates a results table from a proteomics dataset
on which differential enrichment analysis was performed.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Test for differentially expressed proteins
diff <- test_diff(imputed, "control", "Ctrl")
dep <- add_rejections(diff, alpha = 0.05, lfc = 1)

# Get results
results <- get_results(dep)
colnames(results)

significant_proteins <- results[results$significant,]
nrow(significant_proteins)
head(significant_proteins)
}
