% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{test_diff}
\alias{test_diff}
\title{Differential enrichment test}
\usage{
test_diff(
  se,
  type = c("control", "all", "manual"),
  control = NULL,
  test = NULL,
  design_formula = formula(~0 + condition)
)
}
\arguments{
\item{se}{SummarizedExperiment,
Proteomics data (output from \code{\link{make_se}()} or
\code{\link{make_se_parse}()}). It is adviced to first remove
proteins with too many missing values using \code{\link{filter_missval}()},
normalize the data using \code{\link{normalize_vsn}()} and
impute remaining missing values using \code{\link{impute}()}.}

\item{type}{"control", "all" or "manual",
The type of contrasts that will be tested.
This can be all possible pairwise comparisons ("all"),
limited to the comparisons versus the control ("control"), or
manually defined contrasts ("manual").}

\item{control}{Character(1),
The condition to which contrasts are generated if type = "control"
(a control condition would be most appropriate).}

\item{test}{Character,
The contrasts that will be tested if type = "manual".
These should be formatted as "SampleA_vs_SampleB" or
c("SampleA_vs_SampleC", "SampleB_vs_SampleC").}

\item{design_formula}{Formula,
Used to create the design matrix.}
}
\value{
A SummarizedExperiment object
containing fdr estimates of differential expression.
}
\description{
\code{test_diff} performs a differential enrichment test based on
protein-wise linear models and empirical Bayes
statistics using \pkg{limma}. False Discovery Rates are estimated
using \pkg{fdrtool}.
}
\examples{
# Load example
data <- UbiLength
data <- data[data$Reverse != "+" & data$Potential.contaminant != "+",]
data_unique <- make_unique(data, "Gene.names", "Protein.IDs", delim = ";")

# Make SummarizedExperiment
columns <- grep("LFQ.", colnames(data_unique))
exp_design <- UbiLength_ExpDesign
se <- make_se(data_unique, columns, exp_design)

# Filter, normalize and impute missing values
filt <- filter_missval(se, thr = 0)
norm <- normalize_vsn(filt)
imputed <- impute(norm, fun = "MinProb", q = 0.01)

# Test for differentially expressed proteins
diff <- test_diff(imputed, "control", "Ctrl")
diff <- test_diff(imputed, "manual",
    test = c("Ubi4_vs_Ctrl", "Ubi6_vs_Ctrl"))

# Test for differentially expressed proteins with a custom design formula
diff <- test_diff(imputed, "control", "Ctrl",
    design_formula = formula(~ 0 + condition + replicate))
}
