% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{keepRelevantChrs}
\alias{keepRelevantChrs}
\title{keepRelevantChrs}
\usage{
keepRelevantChrs(chrGRangesList, chr = NULL)
}
\arguments{
\item{chrGRangesList}{where each element is a chromosome,
tipically created with cutGRangesPerChromosome.}

\item{chr}{a character vector of chromosomes names of the form "chr#".}
}
\value{
the input chrGRangesList with only the relevat chromosomes.
}
\description{
subselect a list of GRanges created with
cutGRangesPerChromosome returning only the relevant chromosomes GRanges.
}
\examples{
library("GenomicRanges")
gr1 <- GRanges(
            seqnames=Rle(c("chr1", "chr2", "chr1", "chr3"), c(1, 3, 2, 4)),
            ranges=IRanges(1:10, end=10),
            strand=Rle(strand(c("-", "+", "*", "+", "-")), c(1, 2, 2, 3, 2)),
            seqlengths=c(chr1=11, chr2=12, chr3=13))
grlc <- cutGRangesPerChromosome(gr1)
(grlChr <- keepRelevantChrs(grlc, c("chr1", "chr3")))
}
