% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{readFilesAsGRangesList}
\alias{readFilesAsGRangesList}
\title{readFilesAsGRangesList}
\usage{
readFilesAsGRangesList(
  filePath,
  fileType = c("bam", "bed", "bed.zip", "narrow", "broad"),
  genomeName = NULL,
  onlyStdChrs = TRUE,
  arePeaks = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{filePath}{the path of input files.}

\item{fileType}{the type of the files (bam/bed/bed.zip/narrow/broad).}

\item{genomeName}{the genome code to associate to the files. (recommended)
(i.e. "mm9", "hg17")}

\item{onlyStdChrs}{a flag to keep only standard chromosomes.}

\item{arePeaks}{a flag indicating if the files contain peaks.}

\item{verbose}{verbose output flag.}
}
\value{
a GRangesList object
}
\description{
Takes in input the path of bam/bed files to process and stores
them in a GRangesList object, named with filePath/filenames.
(for lazy people)
}
\examples{
files.path <- system.file("extdata/bam", package="DEScan2")
grl <- readFilesAsGRangesList(filePath=files.path, fileType="bam",
                                genomeName="mm9", onlyStdChrs=TRUE,
                                verbose=TRUE)
class(grl)
names(grl)
grl
}
