% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{setGRGenomeInfo}
\alias{setGRGenomeInfo}
\title{setGRGenomeInfo
given a genome code (i.e. "mm9","mm10","hg19","hg38") retrieve the SeqInfo of
that genome and assigns it to the input GRanges. Finally filters out those
Infos not necessary to the GRanges.}
\usage{
setGRGenomeInfo(GRanges, genomeName = NULL, verbose = FALSE)
}
\arguments{
\item{GRanges}{a GRanges object.}

\item{genomeName}{a genome code (i.e. "mm9")}

\item{verbose}{verbose output}
}
\value{
a GRanges object with the seqinfo of the genome code
}
\description{
setGRGenomeInfo
given a genome code (i.e. "mm9","mm10","hg19","hg38") retrieve the SeqInfo of
that genome and assigns it to the input GRanges. Finally filters out those
Infos not necessary to the GRanges.
}
\examples{
library("GenomicRanges")
gr <- GRanges(
        seqnames=Rle(c("chr1", "chr2", "chr1", "chr3"), c(1, 3, 2, 4)),
        ranges=IRanges(1:10, end=10),
        strand=Rle(strand(c("-", "+", "*", "+", "-")), c(1, 2, 2, 3, 2)),
        seqlengths=c(chr1=11, chr2=12, chr3=13))
mm9gr <- setGRGenomeInfo(GRanges=gr, genomeName="mm9", verbose=TRUE)
}
