% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{plotMethylationProfileFromData}
\alias{plotMethylationProfileFromData}
\title{Plot methylation profile from data}
\usage{
plotMethylationProfileFromData(
  methylationData1,
  methylationData2 = NULL,
  regions = NULL,
  conditionsNames = NULL,
  context = "CG",
  windowSize = NULL,
  autoscale = FALSE,
  labels = NULL,
  col = NULL,
  pch = c(1, 0, 16, 2, 15, 17),
  lty = c(4, 1, 3, 2, 6, 5),
  contextPerRow = TRUE
)
}
\arguments{
\item{methylationData1}{the methylation data in condition 1
(see \code{\link{methylationDataList}}).}

\item{methylationData2}{the methylation data in condition 2
(see \code{\link{methylationDataList}}). This is optional.}

\item{regions}{a \code{\link{GRanges}} object with the regions where to plot
the profiles.}

\item{conditionsNames}{the names of the two conditions. This will be used to
plot the legend.}

\item{context}{a \code{vector} with all contexts in which the DMRs are
computed (\code{"CG"}, \code{"CHG"} or \code{"CHH"}).}

\item{windowSize}{a \code{numeric} value indicating the size of the window in
which methylation is averaged.}

\item{autoscale}{a \code{logical} value indicating whether the values are
autoscalled for each context or not.}

\item{labels}{a \code{vector} of \code{character} used to add a subfigure
character to the plot. If \code{NULL} nothing is added.}

\item{col}{a \code{character} vector with the colours. It needs to contain a
minimum of 2 colours per condition. If not or if \code{NULL}, the defalut
colours will be used.}

\item{pch}{the R symbols used to plot the data It needs to contain a minimum
of 2 symbols per condition. If not or if \code{NULL}, the defalut symbols
will be used.}

\item{lty}{the line types used to plot the data. It needs to contain a
minimum of 2 line types per condition. If not or if \code{NULL}, the defalut
line types will be used.}

\item{contextPerRow}{a \code{logical} value indicating if the each row
represents an individual context. If \code{FALSE}, each column will represent
an individual context.}
}
\value{
Invisibly returns \code{NULL}
}
\description{
This function plots the low resolution profiles for all bisulfite sequencing
data.
}
\examples{


# load the methylation data
data(methylationDataList)

#plot the low resolution profile at 10 Kb resolution
par(mar=c(4, 4, 3, 1)+0.1)
plotMethylationProfileFromData(methylationDataList[["WT"]],
                               methylationDataList[["met1-3"]],
                               conditionsNames=c("WT", "met1-3"),
                               windowSize = 20000, autoscale = TRUE,
                               context = c("CHG"))

\dontrun{
#plot the low resolution profile at 5 Kb resolution
par(mar=c(4, 4, 3, 1)+0.1)
plotMethylationProfileFromData(methylationDataList[["WT"]],
                               methylationDataList[["met1-3"]],
                               conditionsNames=c("WT", "met1-3"),
                               windowSize = 5000, autoscale = TRUE,
                               context = c("CG", "CHG", "CHH"),
                               labels = LETTERS)
}

}
\seealso{
\code{\link{plotMethylationProfile}},
\code{\link{computeMethylationProfile}} and \code{\link{methylationDataList}}
}
\author{
Nicolae Radu Zabet
}
