% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{lambdas2Test}
\alias{lambdas2Test}
\alias{lambdas2Test,DNEA-method}
\title{Access the lambda values tested during
hyper parameter optimization}
\usage{
lambdas2Test(x)

\S4method{lambdas2Test}{DNEA}(x)
}
\arguments{
\item{x}{A \code{\link{DNEA}} or
\code{\link{collapsed_DNEA}} object.}
}
\value{
The lambda values to evaluate in optimization.
}
\description{
The function takes as input a \code{\link{DNEA}}
object and returns the lambda values that were testing
during hyper parameter optimization performed via
\code{\link{BICtune}}.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

lambdas2Test(dnw)
}
\seealso{
\code{\link{BICtune}}
}
\author{
Christopher Patsalis
}
