\name{DTA.estimate}
\alias{DTA.estimate}
\title{Estimation of synthesis and decay rates}
\description{DTA.estimate uses an experiment, given by a phenotype matrix, data matrix and the number of uridines for each gene to estimate synthesis and decay rate of the genes.}
\usage{
DTA.estimate(phenomat = NULL,datamat = NULL,tnumber = NULL,reliable = NULL,ccl = NULL,mRNAs = NULL,mediancenter = TRUE,usefractions = "LandT",LtoTratio = NULL,ratiomethod = "tls",largest = 5,weighted = TRUE,relevant = NULL,upper = 700,lower = 500,error = TRUE,samplesize = 1000,confidence.range = c(0.025,0.975),bicor = TRUE,check = TRUE,condition = "",save.plots = FALSE,resolution = 1,notinR = FALSE,RStudio = FALSE,folder = NULL,fileformat = "jpeg",totaloverwt = 1,simulation = FALSE,sim.object = NULL)
}
\arguments{
  \item{phenomat}{A phenotype matrix, containing the design of the experiment as produced by \code{DTA.phenomat}. Columns are name, fraction (U=unlabebeld, L=labeled, T=total), time and nr (=replicate number). Rows represent individual experiments.}
  \item{datamat}{A matrix, containing the measurements from U, L and T, according to the design given in phenomat. Matrix should only contain the rows of phenomat as columns.}
  \item{tnumber}{Integer vector, containing the numbers of uridine residues for each transcript. Elements should have the rownames of datamat.}
  \item{ccl}{The cell cycle length of the cells (optional). Is not modeled, if not set.}
  \item{mRNAs}{Estimated number of mRNAs in a cell (optional).}
  \item{reliable}{Vector of 'reliable' genes, which are used for parameter estimation.}
  \item{mediancenter}{Should the quotient Labeled/Total resp. Unlabeled/Total be rescaled to a common median over it's replicates before building the genewise median.}
  \item{usefractions}{From which fractions should the decay rate be calculated: "LandT", "UandT" or "both".}
  \item{LtoTratio}{Coefficient to rescale Labeled/Total. Is estimated from the data, if not specified. See ratiomethod. Altering this parameter leads to a altered median half-life. For details, see supplemental material of Sun et al. (see references).}
  \item{ratiomethod}{Choose the regression method to be used, possible methods are: "tls", "bias" and "lm". For details, see supplemental material of Sun et al. (see references). Method to estimate the parameter \code{LtoTratio}, which determines the median half-life of the sample.}
  \item{largest}{Percentage of largest residues from the first regression not to be used in the second regression step. For details, see supplemental material of Sun et al. (see references).}
  \item{weighted}{Should the regression be weighted with 1/(Total^2 + median(Total))?}
  \item{relevant}{Choose the arrays to be used for halflives calculation, vector due to nr (=replicate number) in phenomat. If not set, all arrays are used.}
  \item{check}{If check = TRUE, control messages and plots will be generated.}
  \item{error}{If TRUE, the measurement error is assessed by means of an error model and resampling to gain confidence regions.}
  \item{samplesize}{Error model samplesize for resampling.}
  \item{confidence.range}{Confidence region for error model as quantiles. Interval should be between 0 and 1.}
  \item{bicor}{Should the labeling bias be corrected?}
  \item{condition}{String, to be added to the plotnames if saved.}
  \item{upper}{Upper bound for labeling bias estimation. For details, see supplemental material of Sun et al. (see references).}
  \item{lower}{Lower bound for labeling bias estimation. For details, see supplemental material of Sun et al. (see references).}
  \item{save.plots}{If save.plots = TRUE, control plots will be saved. Please check folder writability.}
  \item{resolution}{Resolution scaling factor for plotting. (Scaled with 72dpi.)}
  \item{notinR}{If TRUE, plots are not plotted in R.}
  \item{RStudio}{For RStudio users. Suppresses the opening of a new device, as RStudio allows only one.}
  \item{folder}{Path to the folder, where to save the plots. Needs to be writable.}
  \item{fileformat}{Fileformat for plots to be saved. See \code{plotit} function (\code{LSD} package). Save the plot as "jpeg", "png", "bmp", "tiff", "ps" or "pdf".}
  \item{totaloverwt}{Only needed when \code{mRNAs} is set. Should give the factor by which the total mRNA of the condition outreaches that of the reference (comparative DTA data).}
  \item{simulation}{True, if data was generated by \code{DTA.generate}.}
  \item{sim.object}{Simulation object created by \code{DTA.generate}.}
}
\value{
\code{DTA.estimate} returns a list, where each entry contains the estimation results for all replicates of one labeling time. Each result contains the following entries
  \item{triples}{Mapping of each fraction and experiment to its corresponding column in the data matrix.}
  \item{plabel}{The labeling efficiency. For details, see supplemental material of Sun et al. (see references).}
  \item{LtoTratio}{Estimated ratio of labeled to total fraction.}
  \item{UtoTratio}{Estimated ratio of unlabeled to total fraction.}
  \item{LtoUratio}{Estimated ratio of labeled to unlabeled fraction.}
  \item{correcteddatamat}{Labeling bias corrected data matrix.}
  \item{drmat}{Decay rates for each replicate. The last column gives the median decay rates.}
  \item{dr}{Median decay rates. The last column of drmat.}
  \item{dr.confidence}{Confidence regions of decay rates.}
  \item{hlmat}{Half-lives for each replicate. The last column gives the median half-lifes.}
  \item{hl}{Median half-lives. The last column of hlmat.}
  \item{hl.confidence}{Confidence regions of half-lives.}
  \item{TEmat}{Total expression for each replicate. The last column gives the median total expression values.}
  \item{TE}{Median total expression values. The last column of TEmat.}
  \item{TE.confidence}{Confidence regions of total expression values.}
  \item{LEmat}{Labeled expression for each replicate. The last column gives the median labeled expression values.}
  \item{LE}{Median labeled expression values. The last column of LEmat.}
  \item{LE.confidence}{Confidence regions of labeled expression values.}
  \item{UEmat}{Unlabeled expression for each replicate. The last column gives the median unlabeled expression values. (Only if unlabeled values exist in the experiment)}
  \item{UE}{Median unlabeled expression values. The last column of UEmat. (Only if unlabeled values exist in the experiment)}
  \item{UE.confidence}{Confidence regions of unlabeled expression values.}
  \item{srmat}{Synthesis rates for each replicate. The last column gives the median synthesis rates.}
  \item{sr}{Median synthesis rates. The last column of srmat.}
  \item{sr.confidence}{Confidence regions of synthesis rates.}
  \item{LtoTmat}{Labeled to total ratio for each replicate. The last column gives the median labeled to total ratios.}
  \item{LtoT}{Median labeled to total ratios. The last column of LtoTmat.}
  \item{LtoT.confidence}{Confidence regions of labeled to total ratios.}
  \item{UtoTmat}{Unlabeled to total ratio for each replicate. The last column gives the median unlabeled to total ratios.}
  \item{UtoT}{Median unlabeled to total ratios. The last column of UtoTmat.}
  \item{UtoT.confidence}{Confidence regions of unlabeled to total ratios.}
  \item{Rsrmat}{Rescaled synthesis rates for each replicate, if parameter \code{mRNAs} is specified. The last column gives the median synthesis rates.}
  \item{Rsr}{Rescaled median synthesis rates. The last column of Rsrmat.}
  \item{globaldrmat}{Decay rate for each replicate. Reciprocally weighted by the total expression. Last element contains (weighted) median decay rate.}
  \item{globaldr}{(Weighted) median decay rate.}
}
\references{
C. Miller, B. Schwalb, K. Maier, D. Schulz, S. Duemcke, B. Zacher, A. Mayer, J. Sydow, L. Marcinowski, L. Doelken, D. E. Martin, A. Tresch, and P. Cramer. Dynamic transcriptome analysis measures rates of mRNA synthesis and decay in yeast. Mol Syst Biol, 7:458, 2011.
M. Sun, B. Schwalb, D. Schulz, N. Pirkl, L. Lariviere, K. Maier, A. Tresch, P. Cramer. Mutual feedback between mRNA synthesis and degradation buffers transcript levels in a eukaryote. Under review.
B. Schwalb, B. Zacher, S. Duemcke, D. Martin, P. Cramer, A. Tresch. Measurement of genome-wide RNA synthesis and decay rates with Dynamic Transcriptome Analysis (DTA/cDTA). Bioinformatics. 
}
\author{Bjoern Schwalb \email{schwalb@lmb.uni-muenchen.de}}
\seealso{
\code{\link[LSD:heatscatter]{heatscatter}}, \code{\link[LSD:plotit]{plotit}}, \code{\link{tls}}
}
\examples{
dataPath = system.file("data", package="DTA")
load(file.path(dataPath, "Miller2011.RData"))

### for control plots set 'check = TRUE' ###

res = DTA.estimate(Sc.phenomat,Sc.datamat,Sc.tnumber,ccl = 150,mRNAs = 60000,reliable = Sc.reliable,check = FALSE)
}
\keyword{methods}

