% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Feature_Selection.R
\name{DaMiR.FBest}
\alias{DaMiR.FBest}
\title{Select best predictors to build Classification Model}
\usage{
DaMiR.FBest(
  data,
  ranking,
  autoselect = c("no", "yes"),
  n.pred = 10,
  th.zscore = 2
)
}
\arguments{
\item{data}{A transposed data frame of expression data.
Rows and Cols should be, respectively, observations and features}

\item{ranking}{A data frame with importance score for each feature,
generated by
 \code{\link{DaMiR.FSort}}}

\item{autoselect}{A flag to specify how to select predictors:
\itemize{
    \item{"no" (default) - Manually: users can specify the number
    of best predictors,
    setting \code{n.pred} argument}
    \item{"yes" - Automatically: users have to specify the importance
     threshold
    defined by the \code{th.zscore} argument; features will be
    accordingly selected}
}}

\item{n.pred}{If \code{autoselect="no"} then the user have to specify
 the number of
predictors; default is 10}

\item{th.zscore}{Threshold of scaled importance score (Z-score);
default value is 2}
}
\value{
A list containing:
\itemize{
  \item A data frame of normalized expression data of the most important
  selected predictors.
  \item A vector with predictors name.
}
}
\description{
This function allows the user to select a subset
of predictors; the number
of predictors can be defined by user or selected automatically.
}
\examples{
# use example data:
data(data_reduced)
data(data_relief)
# select the first 8 predictors rankad by imporatance:
selected_features <- DaMiR.FBest(data_reduced, data_relief, n.pred = 8)
# select predictors by importance but automatically:
selected_features <- DaMiR.FBest(data_reduced, data_relief,
autoselect = "yes", th.zscore = 1.5)

}
\seealso{
\code{\link{DaMiR.FSort}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
