% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_results.R
\name{plotCorrHeatmap}
\alias{plotCorrHeatmap}
\title{Plot correlation heatmap}
\usage{
plotCorrHeatmap(df, method = "spearman")
}
\arguments{
\item{df}{A data.frame of GATC region counts as outputted from [countBamInGatc()].}

\item{method}{The correlation method used. If not specified, will use default of non-parametric spearman's.
* Non-parametric methods are recommended as data does not reliably meet the requirements for parametric analysis.}
}
\value{
A heatmap style plot of the samples, coloured by correlation value.
* Colour spectrum is determined from the minimum correlation as the lowest correlation, the median correlation as the midpoint colour, and 1 as the top colour.
}
\description{
`plotCorrHeatmap` plots the correlation of all available BAM files Dam and Fusion, to visualise the similarity between files.
* uses the non-parametric "spearman's" correlation.
}
\details{
The correlation between Dam_1 and Fusion_1 can be expected to reach ~ 0.7, whereas the correlation between Dam_1 & Dam_3 or Fusion_1 & Fusion_2 would be expected to be closer to ~0.9
}
\examples{
counts.df <- random_counts()
plotCorrHeatmap(counts.df, method = "spearman")
}
