% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gene_express.R
\name{plot_gene_express}
\alias{plot_gene_express}
\title{Plot the gene expression of a list of genes in a SCE object}
\usage{
plot_gene_express(
  sce,
  genes,
  assay_name = "logcounts",
  category = "cellType",
  color_pal = NULL,
  title = NULL,
  plot_points = FALSE,
  ncol = 2,
  plot_type = c("violin", "boxplot"),
  free_y = FALSE
)
}
\arguments{
\item{sce}{A
\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class}
object or one inheriting it.}

\item{genes}{A \code{character()} vector specifying the genes to plot,
this should match the format of \code{rownames(sce)}.}

\item{assay_name}{A \code{character(1)} specifying the name of the
\link[SummarizedExperiment:SummarizedExperiment-class]{assay()} in the
\code{sce} object to use to rank expression values. Defaults to \code{logcounts} since
it typically contains the normalized expression values.}

\item{category}{A \code{character(1)} specifying the name of the categorical
variable to group the cells or nuclei by. Defaults to \code{cellType}.}

\item{color_pal}{A named \code{character(1)} vector that contains a color palette
matching the \code{category} values.}

\item{title}{A \code{character(1)} to title the plot.}

\item{plot_points}{A \code{logical(1)} indicating whether to plot points over the
violin, defaults to \code{FALSE} as these often become over plotted and quite
large (especially when saved as PDF).}

\item{ncol}{An \code{integer(1)} specifying the number of columns for the facet in
the final plot. Defaults to 2.}

\item{plot_type}{A \code{character(1)} specifying whether to plot a 'violin'
(default) or 'boxplot'.}

\item{free_y}{\code{logical(1)} indicating whether to use "free" y-axis between
genes (relevant to \code{facet_wrap}).}
}
\value{
A \code{ggplot()} violin plot for selected genes.
}
\description{
This function plots the expression of one or more genes as a violin plot,
over a user defined category, typically a cell type annotation. The plots are
made using \code{ggplot2}.
}
\examples{
## Using Symbol as rownames makes this more human readable
data("sce_ab")
plot_gene_express(sce = sce_ab, genes = c("G-D1_A"))
plot_gene_express(sce = sce_ab, genes = c("G-D1_A"), plot_type = "boxplot")

# Access example data
if (!exists("sce_DLPFC_example")) sce_DLPFC_example <- fetch_deconvo_data("sce_DLPFC_example")

## plot expression of two genes
plot_gene_express(
    sce = sce_DLPFC_example,
    category = "cellType_broad_hc",
    genes = c("GAD2", "CD22")
)

## plot as boxplot
plot_gene_express(
    sce = sce_DLPFC_example,
    category = "cellType_broad_hc",
    genes = c("GAD2", "CD22"),
    plot_type = "boxplot"
)

## plot points - note this creates large images and is easy to over plot
plot_gene_express(
    sce = sce_DLPFC_example,
    category = "cellType_broad_hc",
    genes = c("GAD2", "CD22"), 
    plot_points = TRUE
)

## with boxplot
plot_gene_express(
    sce = sce_DLPFC_example,
    category = "cellType_broad_hc",
    genes = c("GAD2", "CD22"), 
    plot_points = TRUE,
    plot_type = "boxplot"
)

## Use free y-axis between genes
plot_gene_express(
    sce = sce_DLPFC_example,
    category = "cellType_broad_hc",
    genes = c("GAD2", "CD22"), 
    plot_points = TRUE,
    plot_type = "boxplot",
    free_y = FALSE
)

## Add title
plot_gene_express(
    sce = sce_DLPFC_example,
    category = "cellType_broad_hc",
    genes = c("GAD2", "CD22"),
    title = "My Genes"
)

## Add color pallet
my_cell_colors <- create_cell_colors(cell_types = levels(sce_DLPFC_example$cellType_broad_hc))

plot_gene_express(
    sce = sce_DLPFC_example,
    category = "cellType_broad_hc",
    genes = c("GAD2", "CD22"),
    color_pal =  my_cell_colors,
    plot_type = "boxplot",
    plot_points = TRUE
)

}
\seealso{
Other expression plotting functions: 
\code{\link{plot_marker_express}()},
\code{\link{plot_marker_express_ALL}()},
\code{\link{plot_marker_express_List}()}
}
\concept{expression plotting functions}
