% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreCore.R
\name{calcAUC}
\alias{calcAUC}
\title{Calculate Area Under the Curve (AUC)}
\usage{
calcAUC(xVals, yVals)
}
\arguments{
\item{xVals}{A numeric vector of x-values.}

\item{yVals}{A numeric vector of corresponding y-values.}
}
\value{
A numeric value representing the AUC.
}
\description{
Calculates the Area Under the Curve (AUC) for a given set of x and y values
using the trapezoidal rule.
}
\details{
Not exported. This function calculates the AUC for a given set of x and y
values using the trapezoidal rule. It provides a measure of the area under
the curve formed by the x and y values, which is often used to assess the
performance of models or the shape of a curve.
}
\examples{
\dontrun{
# Get AUC of quadratic curve.
x <- seq_len(10)
y <- x^2
auc <- calcAUC(x, y)
}
}
\author{
Brian S. Roberts
}
\keyword{internal}
