% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreBrowserPlot.R
\name{makePlotGInter}
\alias{makePlotGInter}
\title{Create a GInteractions Object for Plotgardener Arches Plotting}
\usage{
makePlotGInter(
  DegGR,
  CreGR,
  plotRegionGR,
  keepPromCreHits,
  plotUnit,
  maskFoundGene,
  mergeGenePromotersDist
)
}
\arguments{
\item{DegGR}{A \link[GenomicRanges]{GRanges} object representing DEG TSSs.}

\item{CreGR}{A \link[GenomicRanges]{GRanges} object representing CRE regions.}

\item{plotRegionGR}{A \link[GenomicRanges]{GRanges} object specifying the
region of interest for plotting.}

\item{keepPromCreHits}{A \link[S4Vectors]{Hits} object containing filtered
promoter-CRE associations.}

\item{plotUnit}{Numeric value specifying the minimum plot unit width in
base pairs.}

\item{maskFoundGene}{Character specifying the index of column for gene name
in \code{DegGR}.}

\item{mergeGenePromotersDist}{Numeric value specifying the distance in base
pairs within which promoters of the same gene are merged.}
}
\value{
A \link[InteractionSet]{GInteractions} object suitable for arches
plotting in plotgardener.
}
\description{
This function generates a GInteractions object suitable for plotting arches
in plotgardener.
}
\details{
This function takes genomic data, including differential expression data
(\code{DegGR}), CRE data (\code{CreGR}),
a region of interest (\code{plotRegionGR}), TSS-CRE associations
(\code{keepPromCreHits}), and other parameters,
and creates a GInteractions object suitable for plotting arches in
plotgardener.

Not exported. The function processes the data to ensure that promoters and
CREs are in a suitable format for plotting. It merges
promoters within a specified distance (\code{mergeGenePromotersDist}) and
adjusts the width of regions to meet the
minimum plot unit width (\code{plotUnit}). It also handles cases where
promoters and CREs may have been merged or
contain duplicate regions, ensuring correct associations.
This function is meant to run within \link{plotBrowserDegCre}. It will not
run well on unintended inputs.
}
\examples{
\dontrun{
# Create the GInteractions object for plotting
GInterX <- makePlotGInter(DegGR=myDegGR,
                          CreGR=myCreGR,
                          plotRegionGR=myPlotRegionGR,
                          keepPromCreHits=myKeepPromCreHits,
                          plotUnit=5000,
                          maskFoundGene=3,
                          mergeGenePromotersDist=2000)
}

}
\author{
Brian S. Roberts
}
\keyword{internal}
