% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_EC.R
\name{load_EC}
\alias{load_EC}
\title{Create a list containing the equivalence classes objects for the single-cell RNA-seq data}
\usage{
load_EC(
  path_to_EC_counts,
  path_to_EC,
  path_to_cell_id,
  path_to_gene_id,
  sample_ids
)
}
\arguments{
\item{path_to_EC_counts}{a vector of length equals to the number of samples: 
each element indicates the path to the equivalence classes counts of the respective sample (i.e., geqc_counts.mtx file).}

\item{path_to_EC}{a vector of length equals to the number of samples: 
each element indicates the path to the equivalence classes of the respective sample (i.e., gene_eqclass.txt.gz file).}

\item{path_to_cell_id}{a vector of length equals to the number of samples: 
each element indicates the path to the cell ids of the respective sample (i.e., quants_mat_rows.txt file).}

\item{path_to_gene_id}{a vector of length equals to the number of samples: 
each element indicates the path to the gene ids of the respective sample (i.e., quants_mat_cols.txt file).}

\item{sample_ids}{a vector of length equals to the number of samples: 
each element indicates the name of the sample.}
}
\value{
A \code{list} object.
}
\description{
\code{load_EC} imports the single-cell equivalence classes (computed by alevin-fry), and stores them into a list.
}
\examples{
# load internal data to the package:
data_dir = system.file("extdata", package = "DifferentialRegulation")

# specify samples ids:
sample_ids = paste0("organoid", c(1:3, 16:18))
# set directories of each sample input data (obtained via alevin-fry):
base_dir = file.path(data_dir, "alevin-fry", sample_ids)
file.exists(base_dir)

# set paths to USA counts, cell id, gene id, EC counts and ECs:
# Note that alevin-fry needs to be run with `--use-mtx` option
# to store counts in a `quants_mat.mtx` file.
path_to_cell_id = file.path(base_dir,"/alevin/quants_mat_rows.txt")
path_to_gene_id = file.path(base_dir,"/alevin/quants_mat_cols.txt")
path_to_EC_counts = file.path(base_dir,"/alevin/geqc_counts.mtx")
path_to_EC = file.path(base_dir,"/alevin/gene_eqclass.txt.gz")

# load EC counts:
EC_list = load_EC(path_to_EC_counts,
                  path_to_EC,
                  path_to_cell_id,
                  path_to_gene_id,
                  sample_ids)

}
\seealso{
\code{\link{load_USA}}, \code{\link{DifferentialRegulation}}
}
\author{
Simone Tiberi \email{simone.tiberi@unibo.it}
}
