% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_USA.R
\name{load_USA}
\alias{load_USA}
\title{Creates a SingleCellExperiment containing the estimated USA counts for the single-cell RNA-seq data}
\usage{
load_USA(path_to_counts, path_to_cell_id, path_to_gene_id, sample_ids)
}
\arguments{
\item{path_to_counts}{a vector of length equals to the number of samples: 
each element indicates the path to the USA estimated count matrix of the respective sample (i.e., quants_mat.mtx file).}

\item{path_to_cell_id}{a vector of length equals to the number of samples: 
each element indicates the path to the cell ids of the respective sample (i.e., quants_mat_rows.txt file).}

\item{path_to_gene_id}{a vector of length equals to the number of samples: 
each element indicates the path to the gene ids of the respective sample (i.e., quants_mat_cols.txt file).}

\item{sample_ids}{a vector of length equals to the number of samples: 
each element indicates the name of the sample.}
}
\value{
A \code{SingleCellExperiment} object.
}
\description{
\code{load_USA} imports the single-cell estimated USA (Unspliced, Spliced and Ambiguous) 
counts (computed by alevin-fry), and stores them into a \code{SingleCellExperiment} object.
}
\examples{
# load internal data to the package:
data_dir = system.file("extdata", package = "DifferentialRegulation")

# specify samples ids:
sample_ids = paste0("organoid", c(1:3, 16:18))
# set directories of each sample input data (obtained via alevin-fry):
base_dir = file.path(data_dir, "alevin-fry", sample_ids)
file.exists(base_dir)

# set paths to USA counts, cell id and gene id:
# Note that alevin-fry needs to be run with `--use-mtx` option
# to store counts in a `quants_mat.mtx` file.
path_to_counts = file.path(base_dir,"/alevin/quants_mat.mtx")
path_to_cell_id = file.path(base_dir,"/alevin/quants_mat_rows.txt")
path_to_gene_id = file.path(base_dir,"/alevin/quants_mat_cols.txt")

# load USA counts:
sce = load_USA(path_to_counts,
               path_to_cell_id,
               path_to_gene_id,
               sample_ids)

}
\seealso{
\code{\link{load_EC}}, \code{\link{DifferentialRegulation}}
}
\author{
Simone Tiberi \email{simone.tiberi@unibo.it}
}
