% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bulk_pi.R
\name{plot_bulk_pi}
\alias{plot_bulk_pi}
\title{Plot the estimated proportions of US counts in each group - bulk RNA-seq data}
\usage{
plot_bulk_pi(results, transcript_id, CI = TRUE, CI_level = 0.95)
}
\arguments{
\item{results}{a \code{list} of \code{\linkS4class{data.frame}} objects, 
computed via \code{\link{DifferentialRegulation}}.}

\item{transcript_id}{a character, indicating the transcript to plot.}

\item{CI}{a logical ('TRUE' by default), indicating whether to plot a 
profile Wald type confidence interval around the estimated proportions.}

\item{CI_level}{a numeric between 0 and 1, indicating the level of the confidence interval.}
}
\value{
A \code{ggplot} object.
}
\description{
\code{plot_bulk_pi} plots the posterior means of the proportions of US counts, in each group.
If 'CI' is TRUE, a profile Wald type confidence interval will also be added;
the level of the confidence interval is specified by 'CI_level'.
}
\examples{
# see the example of DifferentialRegulation_bulk function:
help(DifferentialRegulation_bulk)

}
\seealso{
\code{\link{DifferentialRegulation_bulk}}
}
\author{
Simone Tiberi \email{simone.tiberi@unibo.it}
}
