% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ARIs}
\alias{ARIs}
\title{ARI Matrix}
\usage{
ARIs(clusMat, unclustered = NULL)
}
\arguments{
\item{clusMat}{The clustering matrix with a row per cell and a column per
clustering label type}

\item{unclustered}{The value assigned to unclustered cells. Default to \code{NULL}}
}
\value{
The ARI matrix
}
\description{
ARI Matrix
}
\details{
In the ARI matrix where each cell \strong{i,j} is the adjusted Rand Index
between columns \strong{i} and \strong{j} of the original \code{clusMat}.
If \code{unclustered} is not NULL, the cells which have been assigned to the
\code{unclustered} cluster will not be counted towards computing the ARI.
}
\examples{
data("clusMat", package = "Dune")
ARIs(clusMat)
}
