% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterDuplexGroups.R
\name{clusterDuplexGroups}
\alias{clusterDuplexGroups}
\title{Cluster RNA duplexes in \code{GInteractions} object}
\usage{
clusterDuplexGroups(
  gi,
  graphdf = NULL,
  maxgap = 40,
  minoverlap = 10,
  id_column = "duplex_id",
  weight_column = "weight",
  fast_greedy = FALSE,
  decompose = FALSE,
  id_columns_grapdf = paste(id_column, c(1, 2), sep = "."),
  min_arm_ratio = 0.3,
  dump_graph = FALSE,
  dump_path = ""
)
}
\arguments{
\item{gi}{\code{GInteractions} object}

\item{graphdf}{Optional. Dataframe representing connection edges between entries in gi
If not provided, graphdf is created inside the function}

\item{maxgap}{For graph creation only. Max shift between arms starts and ends for pair of overlapping reads}

\item{minoverlap}{For graph creation only. Minimum required overlap between either arm for pair of overlapping reads
Other optional arguments, which are not relevant, unless user want to modify clustering
weights or modify clustering in some other way}

\item{id_column}{Optional. Column name in the  \code{GInteractions} metadata,
which was used to index temporary duplex groups, if they are present}

\item{weight_column}{Optional. If graphdf is provided,  field to use for weight overlaps}

\item{fast_greedy}{Optional. Run the fast_greedy algorithm instead of Louvain.
Can speed up calcualtion for the large graphs.}

\item{decompose}{Decompose graph into separate sub-graphs before clustering.}

\item{id_columns_grapdf}{Column in the graph dataframe, which was used for index}

\item{min_arm_ratio}{For graph creation only. Span-to-overlap ratio threshold. If smaller than this value, then edge is not drawn}

\item{dump_graph}{For debug. Export the graph elements. not used}

\item{dump_path}{For debug. PArt to export the graph elements. not used}
}
\value{
\code{GInteractions} object with new \code{dg_id} column
}
\description{
Main method to find duplex groups from the individual interactions
}
\details{
Accepts or creates the connections graphdf dataframe, creates graph with
\code{igraph} package, uses community detection algoritm to call clusters.
New field \code{dg_id} is added to label the clusters (duplex groups).
If no community is found for the read, \code{dg_id} is \code{NA}
}
\examples{
data("RNADuplexesSampleData")
# run preprocessing and filtering
preproc_df <- runDuplexDiscoPreproc(RNADuplexesRawBed, table_type = "bedpe")
preproc_gi <- makeGiFromDf(preproc_df)
preproc_gi <- classifyTwoArmChimeras(preproc_gi,
    min_junction_len = 5,
    junctions_gr = SampleSpliceJncGR, max_sj_shift = 10
)
# collapse duplicates
gi <- collapseIdenticalReads(preproc_gi)$gi
# run global clustering
gi <- clusterDuplexGroups(gi)
# check dg_ids
table(is.na(gi$dg_id))
}
