% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EGSEAclass.R
\docType{class}
\name{EGSEAResults}
\alias{EGSEAResults}
\alias{EGSEAResults-class}
\alias{$,EGSEAResults-method}
\alias{topSets}
\alias{topSets,EGSEAResults-method}
\alias{show,EGSEAResults-method}
\alias{summary,EGSEAResults-method}
\alias{limmaTopTable}
\alias{limmaTopTable,EGSEAResults-method}
\alias{generateReport}
\alias{generateReport,EGSEAResults-method}
\alias{getlimmaResults}
\alias{getlimmaResults,EGSEAResults-method}
\alias{plotHeatmap}
\alias{plotHeatmap,EGSEAResults-method}
\alias{plotSummaryHeatmap}
\alias{plotSummaryHeatmap,EGSEAResults-method}
\alias{plotPathway}
\alias{plotPathway,EGSEAResults-method}
\alias{plotMethods}
\alias{plotMethods,EGSEAResults-method}
\alias{plotSummary}
\alias{plotSummary,EGSEAResults-method}
\alias{plotGOGraph}
\alias{plotGOGraph,EGSEAResults-method}
\alias{plotBars}
\alias{plotBars,EGSEAResults-method}
\alias{showSetByName}
\alias{showSetByName,EGSEAResults-method}
\alias{showSetByID}
\alias{showSetByID,EGSEAResults-method}
\alias{getSetScores}
\alias{getSetScores,EGSEAResults-method}
\title{The EGSEAResults class}
\usage{
\S4method{$}{EGSEAResults}(x, name)

topSets(
  object,
  gs.label = 1,
  contrast = 1,
  sort.by = NULL,
  number = 10,
  names.only = TRUE,
  verbose = TRUE
)

\S4method{show}{EGSEAResults}(object)

\S4method{summary}{EGSEAResults}(object)

limmaTopTable(object, contrast = 1)

generateReport(
  object,
  number = 20,
  sort.by = NULL,
  report.dir = NULL,
  kegg.dir = NULL,
  x.axis = NULL,
  x.cutoff = NULL,
  num.threads = 4,
  print.base = FALSE,
  interactive = FALSE,
  verbose = FALSE
)

getlimmaResults(object)

plotHeatmap(
  object,
  gene.set,
  gs.label = 1,
  contrast = 1,
  file.name = "heatmap",
  format = "pdf",
  fc.colors = c("#67A9CF", "#F7F7F7", "#EF8A62"),
  verbose = TRUE
)

plotSummaryHeatmap(
  object,
  gs.label = 1,
  number = 20,
  sort.by = NULL,
  hm.vals = NULL,
  show.vals = NULL,
  file.name = "sum_heatmap",
  format = "pdf",
  verbose = TRUE
)

plotPathway(
  object,
  gene.set,
  gs.label = 1,
  contrast = 1,
  file.name = "pathway",
  verbose = TRUE
)

plotMethods(
  object,
  gs.label = 1,
  contrast = 1,
  file.name = "methods.mds",
  format = "pdf",
  verbose = TRUE
)

plotSummary(
  object,
  gs.label = 1,
  contrast = 1,
  file.name = "summary",
  format = "pdf",
  x.axis = "p.adj",
  x.cutoff = NULL,
  sort.by = NULL,
  use.names = FALSE,
  interactive = FALSE,
  verbose = TRUE
)

plotGOGraph(
  object,
  gs.label = "c5",
  contrast = 1,
  sort.by = NULL,
  noSig = 5,
  file.name = "c5-top-",
  format = "pdf",
  verbose = TRUE
)

plotBars(
  object,
  gs.label = 1,
  contrast = 1,
  number = 20,
  sort.by = NULL,
  bar.vals = "p.adj",
  file.name = "bars_plot",
  format = "pdf",
  verbose = TRUE
)

showSetByName(object, gs.label = 1, set.name)

showSetByID(object, gs.label = 1, id)

getSetScores(object, gs.label = 1)
}
\arguments{
\item{x}{EGSEAResults object, the analysis result object from  \code{\link{egsea}}, 
\code{\link{egsea.cnt}}
or  \code{\link{egsea.ora}}.}

\item{name}{character, the slot name}

\item{object}{EGSEAResults object, the analysis result object from  \code{\link{egsea}}, 
\code{\link{egsea.cnt}}
or  \code{\link{egsea.ora}}.}

\item{gs.label}{the number or label of the gene set collection of interest.}

\item{contrast}{contrast column number or column name specifying which 
contrast is of interest.
if contrast = 0 or "comparison" and the number of contrasts greater than 1, 
the comparative gene sets are 
retruned.}

\item{sort.by}{character, determines how to order the analysis results in 
the stats table. The accepted values depend on the function used to generate the EGSEA 
results.}

\item{number}{integer, maximum number of gene sets to list}

\item{names.only}{logical, whether to display the EGSEA statistics or not.}

\item{verbose}{logical, whether to print out progress messages and warnings.}

\item{report.dir}{character, directory into which the analysis results are 
written out.}

\item{kegg.dir}{character, the directory of KEGG pathway data file (.xml) 
and image file (.png). 
Default kegg.dir=paste0(report.dir, "/kegg-dir/").}

\item{x.axis}{character, the x-axis of the summary plot. All the 
values accepted by the 
\strong{sort.by} parameter can be used. Default x.axis="p.value".}

\item{x.cutoff}{numeric, cut-off threshold to filter the gene sets of 
the summary plots
based on the values of the \strong{x.axis}. Default 
x.cutoff=NULL.}

\item{num.threads}{numeric, number of CPU cores to be used. Default 
num.threads=4.}

\item{print.base}{logical, whether to write out the analysis results of the base methods.
Default is False.}

\item{interactive}{logical, whether to generate interactive tables and plots. 
Note this might dramatically increase the size of the EGSEA report.}

\item{gene.set}{character, the name of the gene set. 
See the output of \code{\link{topSets}}.}

\item{file.name}{character, the prefix of the output file name.}

\item{format}{character, takes "pdf" or "png".}

\item{fc.colors}{vector, determines the fold change colors of the heatmap. 
Three colors of the negative, zero and positive log fold changes,
respectively, should be assigned. Default is c( "#67A9CF", "#F7F7F7", "#EF8A62"). These 
colors were generated using \code{rev(RColorBrewer::brewer.pal(3, "RdBu"))}}

\item{hm.vals}{character, determines which EGSEA score values are used to draw the map.
Default is NULL which implies using the sort.by score.}

\item{show.vals}{character, determines which EGSEA score values are displayed on the map.
Default is NULL which does not show anything.}

\item{use.names}{logical, determines whether to display the GeneSet IDs or GeneSet Names.
Default is FALSE.}

\item{noSig}{numeric, number of significant GO terms to be displayed. A number larger than 
5 might not work due to the size of the generated graph.}

\item{bar.vals}{character, determines which EGSEA score values are used to draw the bars.
Default is NULL which implies using the sort.by score.}

\item{set.name}{character, a vector of gene set names as they appear in \code{\link{topSets}}.}

\item{id}{character, a vector of gene set IDs as they appears in the 
\code{\link{plotSummary}}.}
}
\value{
\code{$} returns the selected slot.

\code{topSets} returns a dataframe of top gene sets with the calculated statistics for each if 
names.only = FALSE.

\code{show} does not return data.

\code{summary} does not return data.

\code{limmaTopTable} returns a dataframe.

\code{generateReport} does not return data but creates an HTML report.

\code{getlimmaResults} returns an MArrayLM object.

\code{plotHeatmap} does not return data but creates image and CSV files.

\code{plotSummaryHeatmap} does not return data but creates image and CSV files.

\code{plotPathway} does not return data but creates a file.

\code{plotMethods} does not reutrn data but creates an image file.

\code{plotSummary} does not return data but creates an image file.

\code{plotGOGraph} does not return data but creates an image file.

\code{plotBars} does not reutrn data but creates an image file.

\code{showSetByName} does not return data

\code{showSetByID} does not return data.

\code{getSetScores} returnsa a dataframe where rows are gene sets and 
columns are samples.
}
\description{
The \code{EGSEAResults} class stores the results of an EGSEA analysis.

The opertator \code{$} extracts a slot from an object of class EGSEAResults.

\code{topSets} extracts a table of the top-ranked gene sets from an EGSEA 
analysis.

\code{show} displays the parameters of an EGSEAResults object

\code{summary} displays a brief summary of the analysis results 
stored in an EGSEAResults object

\code{limmaTopTable} returns a dataframe of the top table of the 
limma analysis for a given contrast.

\code{generateReport} creates an HTML report for the EGSEA analysis that
enables users to seamlessly browse the test results.

\code{getlimmaResults} returns the linear model fit produced by
 \code{limma::eBayes}.

\code{plotHeatmap} generates a heatmap of fold changes for a selected gene set.

\code{plotSummaryHeatmap} generates a summary heatmap for the top n gene 
sets of the comparative analysis across multiple contrasts.

\code{plotPathway} generates a visual map for a selected KEGG pathway with
the gene fold changes overalid on it.

\code{plotMethods} generates a multi-dimensional scaling (MDS) plot
 for the gene set rankings of different base GSE methods

\code{plotSummary} generates a Summary plot for EGSEA analysis.

\code{plotGOGraph} generates a graph of the top significant GO terms in 
a GO term collection, which could be c5 from MSigDB or Gene Ontolog from the GeneSetDB.

\code{plotBars} generates a multi-dimensional scaling (MDS) plot
 for the gene set rankings of different base GSE methods

\code{showSetByname} shows the details of a given gene set indicated by name.

\code{showSetByID} shows the details of a given gene set indicated by ID.

\code{getSetScores} returns a dataframe of the gene set enrichment scores 
per sample. This can be only calculated using specific base methods, namely, "ssgsea".
}
\details{
The \code{EGSEAResults} class is used by \code{egsea}, \code{egsea.cnt} and
\code{egsea.ora} to store the results of an EGSEA analysis. This helps in mining the 
analysis results and generating customized tables and plots.

\code{limmaTopTable} output can be understood from \code{limma::topTable}.

EGSEA report is an interactive HTML report that is generated to
enable a swift navigation through the results of an EGSEA analysis. The following pages 
are generated for each gene set collection and contrast/comparison: \cr
1. Stats Table page shows the detailed statistics of the EGSEA analysis for the 
\code{display.top} gene sets. It shows the EGSEA scores, individual rankings and 
additional annotation for each gene set. Hyperlinks to the source of each gene set
can be seen in this table when they are available. The "Direction" column shows the regulation
direction of a gene set which is calculated based on the \code{logFC}, which is
either calculated from the limma differential expression analysis or provided by the user. 
The method \code{topSets} can be used to generate custom Stats Table. \cr
2. Heatmaps page shows the heatmaps of the gene fold changes for the gene sets that are
presented in the Stats Table page. Red indicates up-regulation
while blue indicates down-regulation. Only genes that appear in the input expression/count 
matrix are visualized in the heat map. Gene names are coloured based on their 
statistical significance in the \code{limma} differential expression analysis. 
The "Interpret Results" link below each heat map allows the user to download the 
original heat map values along with additional statistics from \code{limma} DE analysis (
if available) so that they can be used to perform further analysis in R, e.g., customizing 
the heat map visualization. Additional heat maps can be generated and customized
 using the method \code{plotHeatmap}. \cr
3. Summary Plots page  shows the methods ranking plot along with the summary plots of 
EGSEA analysis. The method plot uses multidimensional scaling (MDS) to visualize the 
ranking of individual methods on a given gene set collection. The summary plots are 
bubble plots that visualize the distribution of gene sets based on the EGSEA
Significance Score and another EGSEA score (default, p-value). 
Two summary plots are generated: ranking and directional plots. Each gene set is 
reprersented with a bubble which is coloured based on the EGSEA ranking (in ranking
plots ) or gene set regulation direction (in directional plots) and sized based on the 
gene set cardinality (in ranking plots) or EGSEA Significance score (in directional plots).
Since the EGSEA "Significance Score" is proportional to the p-value and the 
absolute fold changes, it could be useful to highlight gene sets that
have high Significance scores. The blue labels on the summary plot indicate 
gene sets that do not appear in the top 10 list of gene sets based on the "sort.by" 
argument (black labels) yet they appear in the top 5 list of gene sets based on 
the EGSEA "Significance Score". If two contrasts are provided, the rank is calculated 
based on the "comparison" analysis results and the "Significance Score" is calculated 
as the mean. The method \code{plotSummary} can be used to customize the Summary plots by 
changing the x-axis score
and filtering bubbles based on the values of the x-axis. The method \code{plotMethods} can be
used to generate Method plots. \cr
4. Pathways page shows the KEGG pathways for the gene sets that are presented in the
Stats Table of a KEGG gene set collection. The gene fold changes are overlaid on the 
pathway maps and coloured based on the gene regulation direction: blue for down-regulation
and red for up-regulation. The method \code{plotPathway} can be used to generate
additional pathway maps. Note that this page only appears if a KEGG gene set collection
is used in the EGSEA analysis. \cr
5. Go Graphs page shows the Gene Ontology graphs for top 5 GO terms in each of 
three GO categories: Biological Processes (BP), Molecular Functions (MF), 
and Cellular Components (CC). Nodes are coloured based on the default \code{sort.by}
score where red indicates high significance and yellow indicates low significance. 
The method \code{plotGOGraph} can be used to customize GO graphs by 
changing the default sorting score and the number of significance nodes that can be
visualized. It is recommended that a small number of nodes is selected. Note that
this page only appears if a Gene Ontology gene set collection is used, i.e., for
the c5 collection from MSigDB or the gsdbgo collection from GeneSetDB. \cr
\cr
Finally, the "Interpret Results" hyperlink in the EGSEA report allows the user to download
the fold changes and limma analysis results and thus improve the interpretation of the results.

\code{getlimmaResults}'s output can be manipulated using
 \code{limma::topTable} and \code{limma::topTreat}.

\code{plotHeatmap} fold changes are colored based on the \code{fc.colors} and 
only genes that appear in the EGSEA analysis are visualized in the heatmap. Gene names 
are coloured based on the statistical significance level from limma DE analysis.

\code{plotSummaryHeatmap} creates a summary heatmap for the rankings
of top \code{number} gene sets of the comparative analysis across all the contrasts. The
\code{show.vals} score can be displayed on the heatmap for each gene set. This can
help to identify gene sets that are highly ranked/sgnificant across multiple
contrasts.

\code{plotSummary} generates a Summmary Plot for an EGSEA analysis.
Since the EGSEA "Significance Score" is proportional to the p-value and the 
absolute fold changes, it could be useful to highlight gene sets that
have high Significance scores. The blue labels on the summary plot indicate 
gene sets that do not apear in the top 10 list of gene sets based on the "sort.by" 
argument (black labels) yet they appear in the top 5 list of gene sets based on 
the EGSEA "Significance Score". If two contrasts are provided, the rank is calculated 
based on the "comparison" analysis results and the "Significance Score" is calculated 
as the mean. If \code{sort.by = NULL}, the slot \code{sort.by} of the \code{object} 
is used to order gene sets.
}
\section{Slots}{

\describe{
\item{\code{results}}{list, EGSEA analysis results}

\item{\code{limmaResults}}{MArrayLM, is a limma linear fit model}

\item{\code{contr.names}}{character, the contrasts defined in the analysis}

\item{\code{contrast}}{double, an N x L matrix indicates the contrasts of the 
linear model coefficients for which the test is required. N is the number of 
columns of the design matrix and L is number of contrasts. Can be also a vector 
of integers that specify the columns of the design matrix.}

\item{\code{sampleSize}}{numeric, number of samples}

\item{\code{gs.annots}}{list, the gene set collection annotation index}

\item{\code{baseMethods}}{character, vector of base GSE methods}

\item{\code{baseInfo}}{list, additional information on the base methods (e.g., version).}

\item{\code{combineMethod}}{character, the p-value combining method}

\item{\code{sort.by}}{character, the results ordering argument}

\item{\code{symbolsMap}}{data.frame, the mapping between Entrez IDs and Gene Symbols}

\item{\code{logFC}}{matrix, the logFC matrix of contrasts}

\item{\code{logFC.calculated}}{character, indicates whether the logFC was calculated using
limma DE analysis.}

\item{\code{sum.plot.axis}}{character, the x-axis of the summary plot}

\item{\code{sum.plot.cutoff}}{numeric, the cut-off threshold for the summary plot x-axis}

\item{\code{report}}{logical, whether the report was generated}

\item{\code{report.dir}}{character, the directory of the EGSEA HTML report}

\item{\code{egsea.version}}{character, the version of EGSEA package}

\item{\code{egseaData.version}}{character, the version of EGSEAdata package}
}}

\examples{
# Exampple of EGSEAResults
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
print(gsa$baseMethods)

# Example of topSets
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
topSets(gsa,  gs.label="kegg",contrast=1, number = 10)
topSets(gsa,  gs.label=1, contrast=1, sort.by="ora", number = 10, 
names.only=FALSE)
topSets(gsa,  gs.label="kegg",contrast=0, number = 10)

# Example of show
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
show(gsa)

# Example of summary
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
summary(gsa)

# Example of limmaTopTable
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
colnames(limmaTopTable(gsa))
head(limmaTopTable(gsa))

# Example of generateReport
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
# generateReport(gsa)

# Example of getlimmaResults
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
fit = getlimmaResults(gsa)
class(fit)
names(fit)

# Example of plotHeatmap
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
plotHeatmap(gsa, "Asthma", gs.label="kegg")
plotHeatmap(gsa, "Asthma", gs.label="kegg", contrast = "comparison", 
file.name = "asthma.hm.cmp")

# Example of plotSummaryHeatmap
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
plotSummaryHeatmap(gsa, gs.label="kegg")

# Example of plotPathway
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
plotPathway(gsa, gs.label="kegg", "Asthma")
plotPathway(gsa, gs.label="kegg", "Asthma", contrast="comparison", 
file.name = "asthma.map.cmp")

# Example of plotMethods
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
plotMethods(gsa)

# Example of plotSummary
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
plotSummary(gsa)
plotSummary(gsa, contrast=c(1,2), file.name = "summary.cmp")

# Example of plotGOGraph
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
plotGOGraph(gsa, sort.by="avg.rank")

# Example of plotBars
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
plotBars(gsa)

# Example of showSetByName
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
showSetByName(gsa, "kegg", "Asthma")

# Example of showSetByID
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
showSetByID(gsa, "kegg", "hsa04060")

# Example of getSetScores
library(EGSEAdata)
data(il13.gsa)
gsa = il13.gsa
class(gsa)
head(getSetScores(gsa, "kegg"))

}
