% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_function.R
\name{get.permu}
\alias{get.permu}
\title{get.permu to generate permutation results for calculation of empirical P values for
each enhancer-gene linkage.}
\usage{
get.permu(data,
          geneID,
          methy = NULL,
          unmethy = NULL,
          percentage = 0.2,
          rm.probes = NULL,
          correlation = "negative",
          permu.size = 10000,
          permu.dir = NULL,
          cores = 1)
}
\arguments{
\item{data}{A multiAssayExperiment with DNA methylation and Gene Expression data. See \code{\link{createMAE}} function.}

\item{geneID}{A vector lists the genes' ID.}

\item{methy}{Index of M (methylated) group.}

\item{unmethy}{Index of U (unmethylated) group.}

\item{percentage}{A number ranges from 0 to 1 specifying the percentage of samples of group 1 and group 2
groups used to link probes to genes. Default is 0.2.}

\item{rm.probes}{A vector lists the probes name.}

\item{correlation}{Type of correlation to identify. Default is negative: look for hypomethylation and increase target expression.}

\item{permu.size}{A number specify the times of permuation. Default is 10000.}

\item{permu.dir}{A path where the output of permuation will be.}

\item{cores}{A interger which defines number of core to be used in parallel process.
Default is 1: don't use parallel process.}
}
\value{
Permutations
}
\description{
get.permu is a function to use the same statistic model to calculate random enhancer-gene
pairs. Based on the permutation value, empirical P value can be calculated for the
real enhancer-gene pair (see reference).
}
\note{
Permutation is the most time consuming step. It is recommended to use multiple
cores for this step. Default permutation time is 1000 which may need 12 hrs by 4 cores.
However 10,000 permutations is recommended to get high confidence results. But it may cost 2 days.
}
\examples{
data <- ELMER:::getdata("elmer.data.example")
permu <-get.permu(data = data,
                  geneID=rownames(getExp(data)),
                  rm.probes=c("cg00329272","cg10097755"),
                  permu.size=5)
}
\references{
Yao, Lijing, et al. "Inferring regulatory element landscapes and transcription
factor networks from cancer methylomes." Genome biology 16.1 (2015): 1.
}
\author{
Lijing Yao (creator: lijingya@usc.edu)
Tiago C Silva (maintainer: tiagochst@usp.br)
}
