% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{depth_hist}
\alias{depth_hist}
\title{Sample filtering threshold examination plot.}
\usage{
depth_hist(mtrx, th = 50, title_txt = NULL, smry_fun = max, ...)
}
\arguments{
\item{mtrx}{Matrix or data.frame. Rows are positions and columns are samples.}

\item{th}{Numeric. Sample filtering threshold}

\item{title_txt}{figure title.}

\item{smry_fun}{function to calculate summary metric to apply sample filter threshold to}

\item{...}{additional argument for \code{smry_fun} argument.}
}
\value{
ggplot2 object
}
\description{
Sample filtering threshold examination plot.
}
\examples{
data(mtrx_samtools_reticulate)
th <- 50
depth_hist(mtrx_samtools_reticulate,th=th,smry_fun=max)
depth_hist(mtrx_samtools_reticulate,th=th,smry_fun = quantile,prob=0.95)
depth_hist(mtrx_samtools_reticulate,th=th,smry_fun = mean)
}
