% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_celltype_names.R
\name{fix_celltype_names}
\alias{fix_celltype_names}
\title{Fix celltype names}
\usage{
fix_celltype_names(
  celltypes,
  replace_chars = "[-]|[.]|[ ]|[//]|[\\\\/]",
  make_unique = TRUE
)
}
\arguments{
\item{celltypes}{Character vector of celltype names.}

\item{replace_chars}{Regex string of characters to replace
with "_" when renaming columns.}

\item{make_unique}{Make all entries unique.}
}
\value{
Fixed celltype names.
}
\description{
Make sure celltypes don't contain characters that could interfere with
downstream analyses. For example, the R package
\href{https://github.com/neurogenomics/MAGMA_Celltyping}{MAGMA.Celltyping}
cannot have spaces in celltype names because spaces are used as a delimiter
in later steps.
}
\examples{
ct <- c("microglia", "astryocytes", "Pyramidal SS")
ct_fixed <- fix_celltype_names(celltypes = ct)
}
