% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_celltype_table.r
\name{get_celltype_table}
\alias{get_celltype_table}
\title{get_celltype_table}
\usage{
get_celltype_table(annot)
}
\arguments{
\item{annot}{An annotation dataframe, which columns named 'level1class',
'level2class' and 'dataset_name'}
}
\value{
A dataframe with columns 'name', 'level', 'freq' and 'dataset_name'
}
\description{
\code{ get_celltype_table} Generates a table that can be used for
supplemenary tables of publications.
The table lists how many cells are associated with each cell type, the level
of annotation, and the dataset from which it was generated.
}
\examples{
# See PrepLDSC.Rmd for origin of merged_ALLCELLS$annot
cortex_mrna <- ewceData::cortex_mrna()
cortex_mrna$annot$dataset_name <- "cortex_mrna"
celltype_table <- EWCE::get_celltype_table(cortex_mrna$annot)
}
