% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ctd.R
\name{plot_ctd}
\alias{plot_ctd}
\title{Plot \emph{CellTypeData} metrics}
\usage{
plot_ctd(ctd, genes, level = 1, metric = "specificity", show_plot = TRUE)
}
\arguments{
\item{ctd}{CellTypeDataset.}

\item{genes}{Which genes in \code{ctd} to plot.}

\item{level}{Annotation level in \code{ctd} to plot.}

\item{metric}{Which metric in the \code{ctd} to plot:
\itemize{
\item{"mean_exp"}
\item{"specificity"}
\item{"specificity_quantiles"}
}}

\item{show_plot}{Whether to print the plot or simply return it.}
}
\value{
ggplot object.
}
\description{
Plot \emph{CellTypeData} metrics such as mean_exp, specificity and/or
specificity_quantiles.
}
\examples{
ctd <- ewceData::ctd()
plt <- EWCE::plot_ctd(ctd, genes = c("Apoe", "Gfap", "Gapdh"))
}
