% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sct_normalize.R
\name{sct_normalize}
\alias{sct_normalize}
\title{Normalize expression matrix}
\usage{
sct_normalize(exp, as_sparse = TRUE, verbose = TRUE)
}
\arguments{
\item{exp}{Gene x cell expression matrix.}

\item{as_sparse}{Convert \code{exp} to sparse matrix.}

\item{verbose}{Print messages.}
}
\value{
Normalised expression matrix.
}
\description{
Normalize expression matrix by accounting for library size.
Uses \pkg{sctransform}.
}
\examples{
cortex_mrna <- ewceData::cortex_mrna()
exp_sct_normed <- EWCE::sct_normalize(exp = cortex_mrna$exp[1:300, ])
}
