% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyct.R
\name{easyct}
\alias{easyct}
\title{Annotate cell types for scRNA-seq data}
\usage{
easyct(
  data,
  db = "cellmarker",
  genetype = "Entrezid",
  species = "Human",
  tissue = NULL,
  p_cut = 0.5,
  test = "GSEA",
  scoretype = "std"
)
}
\arguments{
\item{data}{A data frame containing the markers, cluster, 
and expression scores; Marker genes should be sorted in each cluster.
Order of the columns should be gene, cluster and expression level score. 
An example data can be loaded using `data(gene_pbmc)`.}

\item{db}{Name of the reference database: cellmarker, clustermole or panglaodb;}

\item{genetype}{Indicate the gene type in the input data frame: "Entrezid" or "symbol".}

\item{species}{Human or Mouse. Human in default.}

\item{tissue}{Tissue types can be specified when running the analysis. Length of tissue can be larger than 1. 
The possible tissues can be seen using `data(cellmarker_tissue)`, `data(clustermole_tissue)` and `data(panglao_tissue)`.}

\item{p_cut}{Cutoff of the P value for GSEA.}

\item{test}{"GSEA" or "fisher"; "GSEA" is used in default.}

\item{scoretype}{Argument used for GSEA. Default value is "std". If all scores are positive, then scoretype should be "pos".}
}
\value{
A list containing the test results for each cluster.
}
\description{
This function is used to run the annotation analysis using either 
GSEA or a modified Fisher's exact test. We expect users to input a data frame 
containing expressed markers, cluster information and the differential score (log fold change). 
The gene lists in that data frame should be sorted by their differential score.
}
\examples{
data(gene_pbmc)
result <- easyct(gene_pbmc, db="cellmarker", species="Human", 
tissue=c("Blood", "Peripheral blood", "Blood vessel",
"Umbilical cord blood", "Venous blood"), p_cut=0.3, test="GSEA", scoretype="pos")

}
