% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_coxph.R
\name{multi_coxph}
\alias{multi_coxph}
\title{multivariate survival analysis using coxph}
\usage{
multi_coxph(dataframe, y_surv, digits = 4, asnumeric = TRUE)
}
\arguments{
\item{dataframe}{Clinic data and covariates ready to be tested. Note that Rows are samples and columns are variables.}

\item{y_surv}{Survival function contain survival data, usually are obtained form Surv() function in survival package.}

\item{digits}{Integer indicating the number of decimal places.}

\item{asnumeric}{indicator that the data will be (True) / not (False) transformed into numeric. Default is true.}
}
\value{
Object of class \code{matrix} with results.
}
\description{
multivariate survival analysis using coxph
}
\examples{
data(demo_survival_data)
data('demo_data',package = "EnMCB")
demo_set<-demo_data$realdata
res<-multi_coxph(t(demo_set),demo_survival_data)
}
\author{
Xin Yu
}
