% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeEpiTxDbFromRMBase.R
\docType{data}
\name{makeEpiTxDbFromRMBase}
\alias{makeEpiTxDbFromRMBase}
\alias{EPITXDB_RMBASE_URL}
\alias{downloadRMBaseFiles}
\alias{getRMBaseDataAsGRanges}
\alias{makeEpiTxDbFromRMBaseFiles}
\alias{listAvailableOrganismsFromRMBase}
\alias{listAvailableGenomesFromRMBase}
\alias{listAvailableModFromRMBase}
\title{Create a \code{EpiTxDb} object from RMBase v2.0 online resources}
\format{
An object of class \code{character} of length 1.
}
\usage{
EPITXDB_RMBASE_URL

downloadRMBaseFiles(organism, genome, modtype)

makeEpiTxDbFromRMBase(
  organism,
  genome,
  modtype,
  tx = NULL,
  sequences = NULL,
  metadata = NULL,
  reassign.ids = FALSE,
  verbose = FALSE
)

getRMBaseDataAsGRanges(files, verbose = FALSE)

makeEpiTxDbFromRMBaseFiles(
  files,
  tx = NULL,
  sequences = NULL,
  metadata = NULL,
  reassign.ids = FALSE,
  verbose = FALSE
)

listAvailableOrganismsFromRMBase()

listAvailableGenomesFromRMBase(organism)

listAvailableModFromRMBase(organism, genome)
}
\arguments{
\item{organism}{A \code{character} value, which must match an organism
descriptor on the RMBase download website.}

\item{genome}{A \code{character} value, which must match a genome
descriptor on the RMBase download website.}

\item{modtype}{A \code{character} value, which must match one or more
modification descriptors on the RMBase download website.}

\item{tx}{A \code{\link[GenomicRanges:GRangesList-class]{GRangesList}} object
which will be used to shift the genomic coordinates to transcript
coordinates. This is optional, but highly recommended. (default:
\code{tx = NULL}).}

\item{sequences}{A named \code{DNAStringSet} or \code{RNAStringSet}, which
will be used to check whether the defined modifications are compatible with
the original base. This uses
\code{\link[Modstrings:separate]{removeIncompatibleModifications()}}
function from the \code{Modstrings} package.}

\item{metadata, reassign.ids}{See \code{\link[=makeEpiTxDb]{makeEpiTxDb}}}

\item{verbose}{\code{TRUE} or \code{FALSE}: Should verbose message be prined?}

\item{files}{From \code{organism}, \code{genome} and \code{modtype} the
available files will be downloaded using the
\code{\link[BiocFileCache:BiocFileCache-class]{BiocFileCache}} interface
and passed on to \code{makeEpiTxDbFromRMBaseFiles}. However, individual
files can be provided as well.}
}
\value{
a \code{EpiTxDb} object.
}
\description{
\code{makeEpiTxDbFromRMBase} will make use of the RMBase v2.0 online
resources.
}
\keyword{datasets}
