% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EventPointer.R
\name{EventPointer}
\alias{EventPointer}
\title{EventPointer}
\usage{
EventPointer(
  Design,
  Contrast,
  ExFit,
  Eventstxt,
  Filter = TRUE,
  Qn = 0.25,
  Statistic = "LogFC",
  PSI = FALSE
)
}
\arguments{
\item{Design}{The design matrix for the experiment.}

\item{Contrast}{The contrast matrix for the experiment.}

\item{ExFit}{aroma.affymetrix pre-processed variable after using
\code{extractDataFrame(affy, addNames=TRUE)}}

\item{Eventstxt}{Path to the EventsFound.txt file generated by CDFfromGTF function.}

\item{Filter}{Boolean variable to indicate if an expression filter is applied}

\item{Qn}{Quantile used to filter the events (Bounded between 0-1, Q1 would be 0.25).}

\item{Statistic}{Statistical test to identify differential splicing events,
must be one of : LogFC, Dif_LogFC or DRS.}

\item{PSI}{Boolean variable to indicate if Delta PSI should be calculated
for every splicing event.}
}
\value{
Data.frame ordered by the splicing p.value . The object contains the different
information for each splicing event such as Gene name, event type,
genomic position, p.value, z.value and delta PSI.
}
\description{
Statistical analysis of alternative splcing events
}
\examples{

   data(ArraysData)

   Dmatrix<-matrix(c(1,1,1,1,0,0,1,1),nrow=4,ncol=2,byrow=FALSE)
   Cmatrix<-t(t(c(0,1)))
   EventsFound<-paste(system.file('extdata',package='EventPointer'),'/EventsFound.txt',sep='')

   Events<-EventPointer(Design=Dmatrix,
                        Contrast=Cmatrix,
                        ExFit=ArraysData,
                        Eventstxt=EventsFound,
                        Filter=TRUE,
                        Qn=0.25,
                        Statistic='LogFC',
                        PSI=TRUE)
}
