% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Events_ReClassification.R
\name{Events_ReClassification}
\alias{Events_ReClassification}
\title{Events_ReClassification}
\usage{
Events_ReClassification(EventTable, SplicingGraph)
}
\arguments{
\item{EventTable}{Table returned by EventDetection_transcriptome. 
Can be easily loaded using the function read.delim as data.frame.}

\item{SplicingGraph}{A list with the splicing graph of all the genes of
a reference transcriptome. This data is returned
 by the function EventDetection_transcriptome.}
}
\value{
A data.frame containing a new column with the new classification ('EventType_new'):
}
\description{
EventPointer can detect splicing events that cannot
 be cataloged in any of the canonical types 
 (Cassette Exon, Alternative 3' or 5' splice site, 
 retained intron and mutually exclusive exon). 
 These events are classified as "Complex Events". 
 With this function, EventPointer reclassifies these
 complex events according to how similar the event 
 is to the canonical events. 
 The same complex event can have several types.
Further, EP adds a new type of event: "multiple skipping exon". 
These events are characterized by presenting several exons in a 
row as alternative exons. If there is only one alternative exon
 we would be talking about a "Casstte Exon".
}
\examples{

   #load splicing graph
data("SG_reclassify")

#load table with info of the events
PathFiles<-system.file("extdata",package="EventPointer")
inputFile <- paste(PathFiles,"/Events_found_class.txt",sep="")
EventTable <- read.delim(file=inputFile)
#this table has the information of 5 complex events.

EventTable_new <- Events_ReClassification(EventTable = EventTable,
                                          SplicingGraph = SG_reclassify)
         
    

}
