% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBipartite.R
\name{plotBipartite}
\alias{plotBipartite}
\title{Internal function to plot a bipartite graph}
\usage{
plotBipartite(graph = NULL, layout = FALSE, ...)
}
\arguments{
\item{graph}{Graph result that must come from the 
hypergeometric test analysis}

\item{layout}{Logical, should the plot be returned as a layout?}

\item{...}{Additional parameters passed to 
\code{\link[igraph]{plot.igraph}}}
}
\value{
If \code{layout = F} then the value 
returned is \code{invisible()}. 
Otherwise, the layout is returned, also in an invisible fashion.
}
\description{
This function plots a bipartite graph, tailored for the hypergeometric 
over representation analysis. As the nodes can only be compounds and 
pathways, the layout is simple and bipartite.
}
\examples{
## This function is internal
data(FELLA.sample)
data(input.sample)
## Enrich input
obj <- enrich(
compounds = input.sample, 
data = FELLA.sample, 
method = "hypergeom")
## Generate the bipartite graph (only in the hypergeometric test)
g <- generateResultsGraph(
method = "hypergeom", 
threshold = 1, 
object = obj, 
data = FELLA.sample)
## Plot it
FELLA:::plotBipartite(g)

}
\keyword{internal}
