% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_filter.R
\name{seq_filter}
\alias{seq_filter}
\title{Remove a set of sequences}
\usage{
seq_filter(input, rm.seq)
}
\arguments{
\item{input}{\code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} object}

\item{rm.seq}{Ccharacter vector with sequences to remove}
}
\value{
Filtered \code{\link[ShortRead:ShortReadQ-class]{ShortReadQ}} 
object
}
\description{
Removes a set of sequences
}
\examples{

require(ShortRead)

set.seed(10)
input <- random_length(30, 3:7)
rm.seq  = c('TGGTC', 'CGGT', 'GTTCT', 'ATA')

# verify that some sequences match
match_before <- unlist(lapply(rm.seq,
 function(x) grep(x, as.character(sread(input)))))

filtered <- seq_filter(input,rm.seq =  rm.seq)

# verify that matching sequences were removed
match_after <- unlist(lapply(rm.seq, 
function(x) grep(x, as.character(sread(filtered)))))

}
\author{
Leandro Roser \email{learoser@gmail.com}
}
