% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcRP.R
\name{calcRP_region}
\alias{calcRP_region}
\title{calcRP_region}
\usage{
calcRP_region(
  mmAnno,
  peakScoreMt,
  Txdb,
  Chrs_included,
  decay_dist = 1000,
  log_transform = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{mmAnno}{the annotated GRange object from mm_geneScan}

\item{peakScoreMt}{peak count matrix. The rownames are feature_id in mmAnno,
while the colnames are sample names}

\item{Txdb}{Txdb}

\item{Chrs_included}{a character vector which represent
chromosome where you want to calculate gene RP in.
If Chromosome is not be set, it will calculate gene RP in all chromosomes in Txdb.}

\item{decay_dist}{decay distance}

\item{log_transform}{whether you want to log and norm your RP}

\item{verbose}{whether you want to report detailed running message}
}
\value{
a MultiAssayExperiment object containg detailed peak-RP-gene relationship
and sumRP info
}
\description{
calculate regulatory potential based on mm_geneScan result and peakCount matrix,
which is useful for ATAC or H3K27ac histone modification data.
}
\examples{

if (require(TxDb.Athaliana.BioMart.plantsmart28)) {
    data("ATAC_normCount")
    library(SummarizedExperiment)
    Txdb <- TxDb.Athaliana.BioMart.plantsmart28
    seqlevels(Txdb) <- paste0("Chr", c(1:5, "M", "C"))

    peak_path <- system.file("extdata", "ATAC.bed.gz", package = "FindIT2")
    peak_GR <- loadPeakFile(peak_path)
    mmAnno <- mm_geneScan(peak_GR, Txdb)

    regionRP <- calcRP_region(
        mmAnno = mmAnno,
        peakScoreMt = ATAC_normCount,
        Txdb = Txdb,
        Chrs_included = "Chr5"
    )

    sumRP <- assays(regionRP)$sumRP
    fullRP <- assays(regionRP)$fullRP
}

}
