% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{AddAnnotation}
\alias{AddAnnotation}
\title{AddAnnotation}
\usage{
AddAnnotation(
  p,
  fsom,
  toAnnotate = NULL,
  prefix = list(metaclusters = "MCL ", clusters = "CL "),
  ...
)
}
\arguments{
\item{p}{Plot to add annotation to. When using \code{\link{PlotStars}},
please use list_insteadof_ggarrange = TRUE.}

\item{fsom}{FlowSOM object that goes with the plot.}

\item{toAnnotate}{A named list with "metaclusters" and/or "clusters" as names
and a vector with the (meta)clusters that need to be 
annotated. Names can be abbreviated. Use a named vector with 
the old names as values and new labels as names for custom 
labeling.}

\item{prefix}{Prefix to be added to labels. Default is "MCL " and "CL " for
metaclusters and clusters respectively.}

\item{...}{Arguments passed to geom_text_repel.}
}
\value{
The updated plot
}
\description{
Add annotation to a FlowSOM plot
}
\examples{

# Identify the files
fcs <- flowCore::read.FCS(system.file("extdata", "68983.fcs", 
                                      package = "FlowSOM"))
# Build a FlowSOM object
flowSOM.res <- FlowSOM(fcs, 
                       scale = TRUE,
                       compensate = TRUE, 
                       transform = TRUE,
                       toTransform = 8:18, 
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)
                       
p <- PlotStars(flowSOM.res, backgroundValues = flowSOM.res$metaclustering,
               list_insteadof_ggarrange = TRUE)
annotationList <- list("metaclusters" = c("CD8 T cells" = "1", "B cells" = "8"),
                   "clusters" = c(97))
AddAnnotation(p, flowSOM.res, toAnnotate = annotationList, 
              prefix = list("metaclusters" = "", clusters = "CL "))

}
