% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVarImpact.R
\name{plotImpactedG4}
\alias{plotImpactedG4}
\title{Sequence Logo of the G4 Sequence and Its Mutant Counterpart}
\usage{
plotImpactedG4(mut_G4 = NULL, keep_gstrand = TRUE)
}
\arguments{
\item{mut_G4}{A \code{GRanges} object containing the mutant G4.
If multiple G4s are provided, only the first is plotted.}

\item{keep_gstrand}{Logical. If \code{TRUE} (default), negative
strand (C-rich) G4 will be displayed in its complementary reversed form.}
}
\value{
A ggplot2-based object containing the G4 sequence logo.
}
\description{
This function visualizes and compares the G4 and its mutant counterpart
using sequence logos.
}
\examples{
if (!requireNamespace("BiocManager", quietly = TRUE)) {
  install.packages("BiocManager")
}

if (!requireNamespace("GenomicRanges", quietly = TRUE)) {
  BiocManager::install("GenomicRanges")
}

if (!requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)) {
  BiocManager::install("BSgenome.Hsapiens.UCSC.hg19")
}

library(GenomicRanges)
library(BSgenome.Hsapiens.UCSC.hg19)

hg19 <- BSgenome.Hsapiens.UCSC.hg19
chr21_seq <- DNAStringSet(hg19$chr21)
# Chromosome name is needed
names(chr21_seq) <- "chr21"

G4 <- G4HunterDetect(chr21_seq)

# Load SNVs
data(snp_gr)

res_snp <- G4VarImpact(G4, snp_gr, ref_col = "ref", alt_col = "alt")
plotImpactedG4(res_snp[1])

}
