#' @title makeVCFHeaderFromGA4GHResponse function
#' @description Convert \code{DataFrame} output from
#' \code{\link{getVariantSet}} function to \code{\link{VCFHeader}} class.
#' @param variantSet \code{DataFrame} generated by
#' \code{\link{getVariantSet}} function.
#' @return \code{\link{VCFHeader}} object.
#' @examples
#' host <- "http://1kgenomes.ga4gh.org/"
#' \dontrun{
#' datasetId <- searchDatasets(host, nrows = 1)$id
#' variantSetId <- searchVariantSets(host, datasetId, nrows = 1)$id
#' variantId <- searchVariants(host, variantSetId, "1", 15031, 15031)$id
#' variant <- getVariant(host, variantId)
#'
#' makeVCFFromGA4GHResponse(variant)
#' }
#' @seealso \code{\link{getVariantSet}}, \code{\link{VCFHeader}},
#' \code{\link{DataFrame}}
#' @export makeVCFHeaderFromGA4GHResponse
makeVCFHeaderFromGA4GHResponse <- function(variantSet)
{
    metadata <- variantSet$metadata[[1]]
    idx.info <- startsWith(metadata$key, "INFO.")
    info <- with(as.data.frame(metadata[idx.info, ]),
        DataFrame(Number = number,
        Type = type, Description = description,
        row.names = sub("^INFO\\.", "", key)))

    idx.format <- startsWith(metadata$key, "FORMAT.")
    format <- with(as.data.frame(metadata[idx.format, ]),
        DataFrame(Number = c(1, number),
        Type = c("String", type), Description = c("Genotype", description),
        row.names = c("GT", sub("^FORMAT\\.", "", key))))

    VCFHeader(header = DataFrameList(INFO = info, FORMAT = format))
}
