% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExpressionLevel.R
\name{getExpressionLevel}
\alias{getExpressionLevel}
\title{getExpressionLevel function}
\usage{
getExpressionLevel(host, expressionLevelId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{expressionLevelId}{ID of the expression level.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get an expression level by its ID.
}
\details{
This function requests \code{GET host/expressionlevels/expressionLevelId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
rnaQuantificationSetId <- searchRnaQuantificationSets(host, datasetId, nrow = 1)$id
rnaQuantificationId <- searchRnaQuantifications(host, rnaQuantificationSetId, nrows = 1)$id
expressionLevelId <- searchExpressionLevels(host, rnaQuantificationId, nrows = 1)$id
getExpressionLevel(host, expressionLevelId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/rna_quantification_service.proto.html#GetExpressionLevel}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchExpressionLevels}}
}
