% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFeature.R
\name{getFeature}
\alias{getFeature}
\title{getFeature function}
\usage{
getFeature(host, featureId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{featureId}{The ID of the feature to be retrieved.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get a feature set by its ID (a line of genomic feature file).
}
\details{
This function requests \code{GET host/features/featureId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
featureSetId <- searchFeatureSets(host, datasetId, nrows = 1)$id
featureId <- searchFeatures(host, featureSetId, nrows = 1)$id
getFeature(host, featureId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/sequence_annotation_service.proto.html#GetFeature}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchFeatures}}
}
