% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{plotDosage}
\alias{plotDosage}
\title{Draw line plots of allele dosage per marker per sample.}
\usage{
plotDosage(
  x,
  coord = NULL,
  chr = NULL,
  ind = 1,
  node = "raw",
  showratio = TRUE,
  dot_fill = c("green", "darkblue"),
  size = 0.8,
  alpha = 0.8,
  line_color = "magenta"
)
}
\arguments{
\item{x}{A \link{GbsrGenotypeData} object.}

\item{coord}{A vector with two integer specifying the number of rows
and columns to draw faceted line plots for chromosomes.}

\item{chr}{A vector of indexes to specify chromosomes to be drawn.}

\item{ind}{An index to specify samples to be drawn.}

\item{node}{Either one of "raw" or "filt" to output raw read data, or filtered read data,
respectively.}

\item{showratio}{If \code{TRUE}, draw dots indicating read ratio.}

\item{dot_fill}{A vector of two strings to indicate the dot colors in the plot. The first and second elements of the vector are set as the colors for the lowest and highest values in the gradient coloring of the dots indicating total read counts par marker.}

\item{size}{A positive number to indicate the dot size in a plot.}

\item{alpha}{A positive number in 0-1 to indicate the dot opacity in a plot.}

\item{line_color}{A string to indicate the line color in the plot.}
}
\value{
A ggplot object.
}
\description{
This function counts a reference allele dosage per marker per sample and
draw line plots of them in facets for each chromosome for each sample.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

plotDosage(gds, ind = 1)

# Close the connection to the GDS file
closeGDS(gds)

}
