% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{getTopNodes}
\alias{getTopNodes}
\title{Retrieve the top nodes (TFs or genes) with respect to either degree or Eigenvector centrality in the filtered \code{\linkS4class{GRN}} object.}
\usage{
getTopNodes(GRN, nodeType, rankType, n = 0.1, use_TF_gene_network = TRUE)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{nodeType}{Character. One of: \code{"gene"} or \code{"TF"}. Node type.}

\item{rankType}{Character. One of: \code{"degree"}, \code{"EV"}. This parameter will determine the criterion to be used to identify the "top" nodes. If set to "degree", the function will select top nodes based on the number of connections they have, i.e. based on their degree-centrality. If set to "EV" it will select the top nodes based on their eigenvector-centrality score in the network.}

\item{n}{Numeric. Default 0.1. If this parameter is passed as a value between [0,1], it is treated as a percentage of top nodes. If the value is passed as an integer >=1 it will be treated as the number of top nodes.}

\item{use_TF_gene_network}{\code{TRUE} or \code{FALSE}. Default \code{TRUE}. Should the TF-gene network be used (\code{TRUE}) or the TF-peak-gene network (\code{FALSE})?}
}
\value{
A data frame with the node names and the corresponding scores used to rank them
}
\description{
This function requires a filtered set of connections in the \code{\linkS4class{GRN}} object as generated by \code{\link{filterGRNAndConnectGenes}}.
\strong{Note: This function, as all \code{get} functions from this package, does NOT return a \code{\linkS4class{GRN}} object.}
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
topGenes = getTopNodes(GRN, nodeType = "gene", rankType = "degree", n = 3)
topTFs = getTopNodes(GRN, nodeType = "TF", rankType = "EV", n = 5)
}
