% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R
\name{nPeaks}
\alias{nPeaks}
\alias{peaks}
\title{Get the number of peaks for a \code{\linkS4class{GRN}} object.}
\usage{
nPeaks(GRN, filter = TRUE)
}
\arguments{
\item{GRN}{Object of class \code{\linkS4class{GRN}}}

\item{filter}{TRUE or FALSE. Default TRUE. Should peaks marked as filtered be included in the count?}
}
\value{
Integer. Number of peaks that are defined in the \code{\linkS4class{GRN}} object, either by excluding (filter = TRUE) or including (filter = FALSE) peaks that are currently marked as \emph{filtered}.
}
\description{
Returns the number of peaks (all or only non-filtered ones) from the provided peak datain the \code{\linkS4class{GRN}} object.
}
\examples{
# See the Workflow vignette on the GRaNIE website for examples
GRN = loadExampleObject()
nPeaks(GRN, filter = TRUE)
nPeaks(GRN, filter = FALSE)
}
\seealso{
\code{\link{nTFs}}

\code{\link{nGenes}}
}
