% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_enrichreport.R
\name{gm_enrichreport}
\alias{gm_enrichreport}
\title{gm_enrichreport: GSEAmining Enrichment Report}
\usage{
gm_enrichreport(
  df,
  hc,
  col_pos = "red",
  col_neg = "blue",
  top = 3,
  output = "gm_report"
)
}
\arguments{
\item{df}{Data frame that contains at least three columns: an ID column for
the gene set names, a NES column with the normalized enrichment score and a
core_enrichment column containing the genes in the leading edge of each
gene set separated by '/'.}

\item{hc}{The output of gm_clust, which is an hclust class object.}

\item{col_pos}{Color to represent positively enriched gene sets. Default
is red.}

\item{col_neg}{Color to represent negatively enriched gene sets. Default
is blue.}

\item{top}{An integer to choose the top most enriched genes to plot per
cluster. The default parameter are the top 3.}

\item{output}{A string to name the output pdf file.}
}
\value{
Generates a pdf file.
}
\description{
Takes the output of gm_clust, which is an hclust class object,
and creates a report in pdf that contains enriched terms and enriched core
genes in gene sets for each cluster. The results of each cluster are plotted
in an independent page.
}
\examples{
#' data(genesets_sel)
gs.cl <- gm_clust(genesets_sel)
\dontrun{gm_enrichreport(genesets_sel, gs.cl)}

}
