% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology.R
\name{plot_module}
\alias{plot_module}
\title{Plot co-expression network}
\usage{
plot_module(
  graph_module,
  hubs = NULL,
  groups = NULL,
  lower_weight_th = NULL,
  upper_weight_th = NULL,
  title = "Module",
  degree_node_scaling = TRUE,
  node_scaling_min = 1,
  edge_scaling_min = 0.2,
  node_scaling_max = 6,
  edge_scaling_max = 1,
  nb_row_legend = 6,
  layout = "auto",
  zoom = 1,
  vertex.label.cex = 0.7,
  vertex.label.color = "gray20",
  vertex.label.family = "Helvetica",
  edge.color = "gray70",
  vertex.frame.color = "white",
  vertex.color = "gray60",
  vertex.label.dist = 1,
  legend_cex = 0.8,
  groups_palette = NULL,
  window_x_min = -1,
  window_x_max = 1,
  window_y_min = -1,
  window_y_max = 1,
  legend = TRUE,
  ...
)
}
\arguments{
\item{graph_module}{igraph object, module to plot.}

\item{hubs}{character vector or numeric vector with names, optionnal,
vector of gene names or vector of numeric values named with gene names.}

\item{groups}{matrix or data.frame, a two cols table with the gene id in the
first one, and the group assignation in the second one.}

\item{lower_weight_th, upper_weight_th}{decimal, weight threshold above
lower_weight_th or below upper_weight_th which edges will be removed.}

\item{title}{string, main title that will be displayed on the plot.}

\item{degree_node_scaling}{boolean, indicates if node size should represent
the degree of this node.}

\item{node_scaling_min, node_scaling_max}{integer, if degree_node_scaling is
TRUE, it is the min/max size of the node, else it is the exact size of all
node.}

\item{edge_scaling_min, edge_scaling_max}{integer, min/max width of the edge}

\item{nb_row_legend}{integer, number of levels in the legend.}

\item{layout}{numeric matrix or function or string, numeric matrix for nodes
coordinates, or function for layout, or name of a layout function available
in \code{igraph}. Default "auto" will choose the best layout depending on
the graph. For more information, see \code{\link{igraph.plotting}}.}

\item{zoom}{integer, scaling factor by which it's possible to have
compact graph (< 1) or larger graph (> 1) display.}

\item{vertex.label.cex, legend_cex}{float, font size for vertex labels. It is
interpreted as a multiplication factor of some device-dependent base font
size. If 0, no labels displayed.}

\item{vertex.label.color, edge.color, vertex.frame.color, vertex.color}{character and/or integer vector , color of the labels.
It may either contain integer values, named colors or RGB specified colors
with three or four bytes. All strings starting with ‘#’ are assumed to be
RGB color specifications. It is possible to mix named color and RGB colors.}

\item{vertex.label.family}{character, font family to be used for vertex
labels.}

\item{vertex.label.dist}{integer, distance of the label from the center of
the vertex. If it is 0 then the label is centered on the vertex. If it is 1
then the label is displayed beside the vertex.}

\item{groups_palette}{character and/or integer vector, vertices group palette
of colors for the groups specified. It may either contain integer values, 
named colors or RGB specified colors with three or four bytes. All strings 
starting with ‘#’ are assumed to be RGB color specifications. It is possible 
to mix named color and RGB colors.}

\item{window_x_min}{decimal, value for the bottom limit of the window.}

\item{window_x_max}{decimal, value for the top limit of the window.}

\item{window_y_min}{decimal, value for the left limit of the window.}

\item{window_y_max}{decimal, value for the right limit of the window.}

\item{legend}{boolean, indicates if the legend should be plotted.}

\item{...}{any other parameter compatible with the
\code{\link[igraph]{plot.igraph}} function.}
}
\value{
matrix, layout of the graph as a two column matrix (x, y)
}
\description{
Display a graph representing the co-expression network and different
informations like hubs, enrichments
}
\details{
Take care of you intend to compare modules' graphs, the same size
of node will not correspond to the same values because of the scaling.
}
\examples{
mat <- matrix(runif(40*40), 40)
g <- build_graph_from_sq_mat(mat)
plot_module(g, lower_weight_th = -0.5, upper_weight_th = 0.5)

}
