% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{path_to_GeDi}
\alias{path_to_GeDi}
\title{Prepare enrichment analysis output data for GeDi}
\usage{
path_to_GeDi(genesets_df, enrichment_package)
}
\arguments{
\item{genesets_df}{Dataframe, a dataframe of the enrichment analysis output
which should be prepared for the use in GeDi.}

\item{enrichment_package}{character, the name of the R package used to conduct
the enrichment analysis. Supported packages are
currently topGO, clusterProfiler, ReactomePA,
enrichR and fgsea.}
}
\value{
A Dataframe of the inout data which can directly be used with the
\link{GeDi} package.
}
\description{
Prepare enrichment analysis output data for GeDi
}
\examples{
genesets_df <- data("macrophage_Reactome_example", package = "GeDi")
genesets_df <- path_to_GeDi(
               genesets_df = macrophage_Reactome_example,
               enrichment_package = "clusterProfiler") 
}
